<?php
defined('FIR') OR exit();
/**
 * The template for displaying Home page content
 */
?>
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="row">
		 	
                             <div class="col-lg-12">

                               <?=$this->message()?>
                               <?=$this->validation()?>

                              </div>
                    
                                <div class="col-sm-12">
                                    <h5 class="mt-2"><?=$this->lang('settings')?></h5>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-3 col-sm-12">
                                            <?php $selected = ($data['m'] == 'details') ? ' active' : ''; ?>
                                            <?php $image = ($data['m'] == 'image') ? ' active' : ''; ?>
                                            <?php $active = ($data['m'] == 'password') ? ' active' : ''; ?>
                                            <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                                 <li><a href="<?=$this->siteUrl()?>/admin/profile/details" class="nav-link text-left<?php echo e($selected); ?>">
                                                  <em class="fa fa-fw fa-user-md text-white"></em>&nbsp;&nbsp;&nbsp;<?=$this->lang('profile')?>
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/admin/profile/image" class="nav-link text-left<?php echo e($image); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp;<?=$this->lang('image')?>
                                                 </a></li>
                                                 <li><a href="<?=$this->siteUrl()?>/admin/profile/password" class="nav-link text-left<?php echo e($active); ?>">
                                                  <em class="fa fa-fw fa-lock text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('change_password')?> 
                                                 </a></li>                                                

                                            </ul>
                                        </div>
                                        <div class="col-md-9 col-sm-12">
		                          <?php if ($data['m'] == 'details') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('edit_profile')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/admin/profile" method="post">

                                                  <div class="form-group">
                                                   <label><?=$this->lang('name')?></label>	
                                                    <input type="text" name="name" class="form-control" value="<?=e($data['admin']['name'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                   <label><?=$this->lang('username')?></label>
                                                    <input type="text" name="username" class="form-control" value="<?=e($data['admin']['username'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                   <label><?=$this->lang('email')?></label>
                                                    <input type="text" name="email" class="form-control" value="<?=e($data['admin']['email'])?>">
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="profile" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'image') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('profile_picture')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:200px; height: 200px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['admin']['imagelocation'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/admin/profile" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="picture" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>    
              
                                 <?php elseif ($data['m'] == 'password') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('change_password')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/admin/profile" method="post">

                                                  <div class="form-group">
                                                   <label><?=$this->lang('current_password')?></label>
                                                    <input type="password" name="password_current" class="form-control" placeholder="<?=$this->lang('current_password')?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                   <label><?=$this->lang('new_password')?></label>
                                                    <input type="password" name="password_new" class="form-control" placeholder="<?=$this->lang('new_password')?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                   <label><?=$this->lang('confirm_new_password')?></label>
                                                    <input type="password" name="password_new_again" class="form-control" placeholder="<?=$this->lang('confirm_new_password')?>"/>
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="password" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>                                       
                                            
                                  <?php endif; ?>            
                                            
                                       
                                        </div><!-- /col-lg-9 -->
                                    </div>
                                </div>                    
                    
                    
                </div> <!-- end col -->
            </div>		
         </div>		
      </div><!-- /.content-wrapper -->